#!/usr/bin/env bash
set -Eeuo pipefail

C_RESET="\033[0m"
C_BLUE="\033[1;36m"
C_GREEN="\033[1;32m"
C_RED="\033[1;31m"
C_GRAY="\033[38;5;245m"

DEV_NAME="DELUXE"
CHECKER_NAME="DELUXE VIP CHK"
TG_CHANNEL="@deluxebxba"


safe_sleep() {
    command -v sleep >/dev/null 2>&1 && sleep "$1" || :
}

on_error() {
    echo -e "\n${C_RED}✖ Error at line $1${C_RESET}"
    echo -e "${C_GRAY}Installer aborted.${C_RESET}"
    exit 1
}
trap 'on_error $LINENO' ERR

spinner() {
    local pid=$1
    local spin='⠋⠙⠹⠸⠼⠴⠦⠧⠇⠏'
    local i=0
    tput civis 2>/dev/null || true
    while kill -0 "$pid" 2>/dev/null; do
        printf "\r ${C_BLUE}%s${C_RESET} Processing..." "${spin:i++%10:1}"
        safe_sleep 0.1
    done
    tput cnorm 2>/dev/null || true
    printf "\r"
}

run_bg() {
    "$@" >/dev/null 2>&1 &
    spinner $!
}

header() {
    clear || true
    echo -e "${C_BLUE}"
    figlet -f slant "DELUXE" 2>/dev/null || echo "DELUXE"
    echo -e "${C_RESET}"
    echo -e "${C_GRAY}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${C_RESET}"
    echo -e "  ${C_GREEN}$CHECKER_NAME • Universal Installer${C_RESET}"
    echo -e "  ${C_WHITE}Dev: $DEV_NAME | TG: $TG_CHANNEL${C_RESET}"
    echo -e "${C_GRAY}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${C_RESET}\n"
}

step() { echo -e "\n${C_BLUE}▶ $1${C_RESET}"; }
ok() { echo -e "${C_GREEN}✔ $1${C_RESET}"; }
fail() { echo -e "${C_RED}✖ $1${C_RESET}"; exit 1; }

if [[ -d "/data/data/com.termux" ]]; then
    PLATFORM="termux"
    PY="python"
    SUDO=""
else
    PLATFORM="linux"
    PY="python3"
    SUDO="sudo"
fi

install_pkg() {
    local pkg="$1"
    command -v "$pkg" >/dev/null 2>&1 && return 0
    if [[ "$PLATFORM" == "termux" ]]; then
        pkg install -y "$pkg"
    else
        $SUDO apt install -y "$pkg"
    fi
}

header
ok "Platform detected: $PLATFORM"

step "Preparing system"
install_pkg figlet
install_pkg nano
install_pkg python
ok "Base tools ready"

TARGET_DIR=$(pwd)
APP="$TARGET_DIR/card.py" 

step "Updating system packages"
if [[ "$PLATFORM" == "termux" ]]; then
    run_bg pkg update -y
else
    run_bg $SUDO apt update -y
fi
ok "System updated"

step "Installing Python dependencies"
run_bg $PY -m pip install --upgrade pip
run_bg $PY -m pip install requests colorama
ok "Python environment ready"

step "Applying permissions"
chmod +x "$APP" 2>/dev/null || true
ok "Permissions applied"

echo -e "\n${C_GREEN}✔ $CHECKER_NAME Installed Successfully${C_RESET}"
echo -e "${C_GRAY}Starting the checker...${C_RESET}\n"

safe_sleep 2

while true; do
    if [[ -f "$APP" ]]; then
        "$PY" "$APP"
    else
        fail "Error: card.py not found! Please save your python code as card.py"
    fi
    echo -e "${C_RED}⚠ Checker stopped. Restarting in 5 seconds...${C_RESET}"
    safe_sleep 5
done